<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-pencil me-2"></i>Edit Biodata / CV
    </h2>
    <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali ke Dashboard
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/biodata/update') ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_lengkap" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" 
                       value="<?= old('nama_lengkap', $biodata['nama_lengkap']) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="nama_panggilan" class="form-label">Nama Panggilan</label>
                <input type="text" class="form-control" id="nama_panggilan" name="nama_panggilan" 
                       value="<?= old('nama_panggilan', $biodata['nama_panggilan'] ?? '') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tempat_lahir" class="form-label">Tempat Lahir</label>
                <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" 
                       value="<?= old('tempat_lahir', $biodata['tempat_lahir'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" 
                       value="<?= old('tanggal_lahir', $biodata['tanggal_lahir'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                <select class="form-select" id="jenis_kelamin" name="jenis_kelamin">
                    <option value="">Pilih</option>
                    <option value="L" <?= old('jenis_kelamin', $biodata['jenis_kelamin'] ?? '') === 'L' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="P" <?= old('jenis_kelamin', $biodata['jenis_kelamin'] ?? '') === 'P' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
        </div>

        <div class="mb-3">
            <label for="alamat" class="form-label">Alamat</label>
            <textarea class="form-control" id="alamat" name="alamat" rows="3"><?= old('alamat', $biodata['alamat'] ?? '') ?></textarea>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="kota" class="form-label">Kota</label>
                <input type="text" class="form-control" id="kota" name="kota" value="<?= old('kota', $biodata['kota'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="provinsi" class="form-label">Provinsi</label>
                <input type="text" class="form-control" id="provinsi" name="provinsi" value="<?= old('provinsi', $biodata['provinsi'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="kode_pos" class="form-label">Kode Pos</label>
                <input type="text" class="form-control" id="kode_pos" name="kode_pos" value="<?= old('kode_pos', $biodata['kode_pos'] ?? '') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="no_telepon" class="form-label">No. Telepon</label>
                <input type="text" class="form-control" id="no_telepon" name="no_telepon" value="<?= old('no_telepon', $biodata['no_telepon'] ?? '') ?>">
            </div>
            <div class="col-md-6 mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email" value="<?= old('email', $biodata['email'] ?? '') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="website" class="form-label">Website</label>
                <input type="url" class="form-control" id="website" name="website" value="<?= old('website', $biodata['website'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="linkedin" class="form-label">LinkedIn</label>
                <input type="url" class="form-control" id="linkedin" name="linkedin" value="<?= old('linkedin', $biodata['linkedin'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="github" class="form-label">GitHub</label>
                <input type="url" class="form-control" id="github" name="github" value="<?= old('github', $biodata['github'] ?? '') ?>">
            </div>
        </div>

        <div class="mb-3">
            <label for="instagram" class="form-label">Instagram</label>
            <input type="url" class="form-control" id="instagram" name="instagram" value="<?= old('instagram', $biodata['instagram'] ?? '') ?>">
        </div>

        <div class="mb-3">
            <label for="foto_profil" class="form-label">Foto Profil</label>
            <?php if ($biodata['foto_profil'] ?? null): ?>
                <div class="mb-2">
                    <?= clickable_image('biodata', $biodata['foto_profil'], 'Foto Profil Saat Ini', 'img-fluid', 200, 200) ?>
                    <p class="text-white small mt-1">Foto saat ini (klik untuk melihat ukuran penuh)</p>
                </div>
            <?php endif; ?>
            <input type="file" class="form-control" id="foto_profil" name="foto_profil" 
                   accept="image/jpeg,image/png,image/gif">
            <small class="text-white">Format: JPG, PNG, GIF (Max: 2MB). Kosongkan jika tidak ingin mengubah.</small>
        </div>

        <div class="mb-3">
            <label for="tentang_saya" class="form-label">Tentang Saya</label>
            <textarea class="form-control" id="tentang_saya" name="tentang_saya" rows="5"><?= old('tentang_saya', $biodata['tentang_saya'] ?? '') ?></textarea>
        </div>

        <div class="mb-3">
            <label for="keahlian" class="form-label">Keahlian</label>
            <textarea class="form-control" id="keahlian" name="keahlian" rows="3" 
                      placeholder="Contoh: PHP, JavaScript, HTML, CSS, MySQL"><?= old('keahlian', $biodata['keahlian'] ?? '') ?></textarea>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Update
            </button>
            <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

